package com.ejie.ab04b.service;

import java.util.List;

import com.ejie.ab04b.exception.AB04BException;
import com.ejie.ab04b.model.DocumentoOS2;
import com.ejie.foldermanagement.xml.DocumentEvent;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JQGridResponseDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0494s00Service generated by UDA, 05-Apr-2017 09:34:34.
 * 
 * @author UDA
 */

public interface DocumentoOS2Service {

	/**
	 * Inserts a single row in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00 Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @return the documento OS 2
	 */
	DocumentoOS2 add(DocumentoOS2 ab0494s00);

	/**
	 * Inserts a single row in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00 temp boolean Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @param temp
	 *            the temp
	 * @return the documento os2
	 */
	DocumentoOS2 add(DocumentoOS2 ab0494s00, boolean temp);

	/**
	 * Inserts a single row in the ab0494s00 table.
	 * 
	 * documents List<DocumentEvent> fechaCreacion String idTramite Long
	 * 
	 * @param documents
	 *            the documents
	 * @param fechaCreacion
	 *            the fecha creacion
	 * @param idTramite
	 *            the id tramite
	 */
	public void addDocumentosSolicitud(List<DocumentEvent> documents,
			String fechaCreacion, Long idTramite);

	/**
	 * Updates a single row in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00 Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @return the documento OS 2
	 */
	DocumentoOS2 update(DocumentoOS2 ab0494s00);

	/**
	 * Finds a single row in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00 Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @return the documento OS 2
	 */
	DocumentoOS2 find(DocumentoOS2 ab0494s00);

	/**
	 * Finds a single row in the Ab0494s00 table.
	 * 
	 * oid String Ab0494s00
	 * 
	 * @param oid
	 *            the oid
	 * @return the documento OS 2
	 */
	DocumentoOS2 findByOid(String oid);

	/**
	 * Finds a single row in the Ab0465s00 table.
	 * 
	 * ab0494s00 Ab0494s00 Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 094 s 00
	 * @return the documento os2
	 */
	public DocumentoOS2 findTemp(DocumentoOS2 ab0494s00);

	/**
	 * Deletes a single row in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 */
	void remove(DocumentoOS2 ab0494s00);

	/**
	 * Deletes a single row in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 */
	void removeTemp(DocumentoOS2 ab0427s00);

	/**
	 * Deletes a single row in the Ab0427s00 table.
	 * 
	 * ab0427s00 Ab0427s00
	 * 
	 * @param ab0427s00
	 *            the ab 0427 s 00
	 */
	void removeTempByApertura(DocumentoOS2 ab0427s00);

	/**
	 * Finds a list of rows in the Ab0494s00 table.
	 * 
	 * ab0494s00 Ab0494s00 jqGridRequestDto JQGridRequestDto List<Ab0494s00>
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	List<DocumentoOS2> findAll(DocumentoOS2 ab0494s00,
			JQGridRequestDto jqGridRequestDto);

	/**
	 * Finds rows in the Ab0494s00 table using like.
	 * 
	 * ab0494s00 Ab0494s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0494s00>
	 * 
	 * @param ab0494s00
	 *            the ab 0494 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<DocumentoOS2> findAllLike(DocumentoOS2 ab0494s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Filter method in the Ab0494s00 table.
	 * 
	 * filterAb0494s00 Ab0494s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean JQGridResponseDto<Ab0494s00>
	 * 
	 * @param filterAb0494s00
	 *            the filter ab 0494 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the JQ grid response dto
	 */
	JQGridResponseDto<DocumentoOS2> filter(DocumentoOS2 filterAb0494s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Searches rows in the Ab0494s00 table.
	 * 
	 * filterAb0494s00 Ab0494s00 searchAb0494s00 Ab0494s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0494s00>>
	 * 
	 * @param filterAb0494s00
	 *            the filter ab 0494 s 00
	 * @param searchAb0494s00
	 *            the search ab 0494 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	List<TableRowDto<DocumentoOS2>> search(DocumentoOS2 filterAb0494s00,
			DocumentoOS2 searchAb0494s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith);

	/**
	 * Reorder the selection made in Ab0494s00 table.
	 * 
	 * filterAb0494s00 Ab0494s00 jqGridRequestDto JQGridRequestDto startsWith
	 * Boolean Object
	 * 
	 * @param filterAb0494s00
	 *            the filter ab 0494 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the object
	 */
	Object reorderSelection(DocumentoOS2 filterAb0494s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith);

	/**
	 * Sube fichero PIF.
	 * 
	 * datosFichero byte[] rutaFichero String nombreFichero String preservaName
	 * boolean DocumentoOs2
	 * 
	 * @param datosFichero
	 *            the datos fichero
	 * @param rutaFichero
	 *            the ruta fichero
	 * @param nombreFichero
	 *            the nombre fichero
	 * @param preservaName
	 *            the preserva name
	 * @return the documento os2
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	public DocumentoOS2 subeFicheroPIF(byte[] datosFichero, String rutaFichero,
			String nombreFichero, boolean preservaName) throws AB04BException;

	/**
	 * Updates a single row in the Ab0494s00 table.
	 * 
	 * documento DocumentoOS2 Ab0494s00
	 * 
	 * @param documento
	 *            the documento
	 * @return the documento OS 2
	 */
	DocumentoOS2 updateFilled(DocumentoOS2 documento);

	/**
	 * Find by tramite.
	 * 
	 * doc the doc the documento OS 2
	 * 
	 * @param doc
	 *            the doc
	 * @return the documento OS 2
	 */
	DocumentoOS2 findByTramite(DocumentoOS2 doc);

	/**
	 * Descargar documento.
	 * 
	 * rutaCompletaFichero String byte[]
	 * 
	 * @param rutaCompletaFichero
	 *            the ruta completa fichero
	 * @return the byte[]
	 * @throws AB04BException
	 *             the AB 04 B exception
	 */
	byte[] descargarDocumento(String rutaCompletaFichero) throws AB04BException;
}
